using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using DarkStrideToolbox;


namespace DarkStrideToolbox
{
	public class DSHoverForm : System.Windows.Forms.Form
	{
		#region Properties
		private System.Drawing.Point m_oStartingMousePt;
		private string m_sCaption;
		private System.Collections.ArrayList m_arrLines;
		#endregion

		#region System Stuff
		private System.Windows.Forms.Panel panelWorkspace;
		private System.Windows.Forms.Timer timerFadeIn;
		private System.Windows.Forms.Timer timerMouseMonitor;
		private System.Windows.Forms.Timer timerFadeOut;
		private System.ComponentModel.IContainer components;
		


		public DSHoverForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.panelWorkspace = new System.Windows.Forms.Panel();
			this.timerFadeIn = new System.Windows.Forms.Timer(this.components);
			this.timerFadeOut = new System.Windows.Forms.Timer(this.components);
			this.timerMouseMonitor = new System.Windows.Forms.Timer(this.components);
			this.SuspendLayout();
			// 
			// panelWorkspace
			// 
			this.panelWorkspace.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.panelWorkspace.Dock = System.Windows.Forms.DockStyle.Fill;
			this.panelWorkspace.Location = new System.Drawing.Point(0, 0);
			this.panelWorkspace.Name = "panelWorkspace";
			this.panelWorkspace.Size = new System.Drawing.Size(208, 266);
			this.panelWorkspace.TabIndex = 0;
			// 
			// timerFadeIn
			// 
			this.timerFadeIn.Tick += new System.EventHandler(this.timerFadeIn_Tick);
			// 
			// timerFadeOut
			// 
			this.timerFadeOut.Tick += new System.EventHandler(this.timerFadeOut_Tick);
			// 
			// timerMouseMonitor
			// 
			this.timerMouseMonitor.Tick += new System.EventHandler(this.timerMouseMonitor_Tick);
			// 
			// DSHoverForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.Info;
			this.ClientSize = new System.Drawing.Size(208, 266);
			this.ControlBox = false;
			this.Controls.Add(this.panelWorkspace);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.None;
			this.Name = "DSHoverForm";
			this.Opacity = 0;
			this.ShowInTaskbar = false;
			this.Text = "DSHoverForm";
			this.Load += new System.EventHandler(this.DSHoverForm_Load);
			this.ResumeLayout(false);

		}
		#endregion


		private void InitScreen()
		{
			System.Windows.Forms.Label lblCaption;
			System.Windows.Forms.Label lblItem;
			string sDesc = "";
			string sTemp = "";
			int dCaptionHeight = 32;
			int dMargin = 5;
			int dCurrentY = dCaptionHeight + dMargin;
			int dLabelHeight = 12;
			float nWidth = 0;
			float nMaxWidth = this.Width - dMargin * 2;


			lblCaption = new Label();
			lblCaption.Text = m_sCaption;
			lblCaption.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			lblCaption.Location = new Point(0, 0);
			lblCaption.Size = new Size(this.Width, dCaptionHeight);
			lblCaption.Font = new System.Drawing.Font("Tahoma", 12F, System.Drawing.FontStyle.Bold);
			this.panelWorkspace.Controls.Add(lblCaption);

			for (int i = 0; i < m_arrLines.Count; i++)
			{
				sDesc = (string)m_arrLines[i];

				do
				{
					lblItem = CreateLabel( sDesc );
					sTemp = sDesc;

					nWidth = GetTextWidth( lblItem,sTemp );
					for( int nRemove=0 ; nRemove< sDesc.Length && nWidth > nMaxWidth ; nRemove++ )
					{
						sTemp = sDesc.Substring(0,sDesc.Length - nRemove );
                        nWidth = GetTextWidth( lblItem,sTemp );
					}

					//Did we run out?  If so then screw it, show all
					if( sTemp.Length == 0 )
					{
						sTemp = sDesc;
						sDesc = "";
					}
					else
					{
						sDesc = sDesc.Substring( sTemp.Length );
					}

					lblItem.Text = sTemp;
					lblItem.Location = new Point(dMargin, dCurrentY);
					lblItem.Size = new Size(this.Width, dLabelHeight + dMargin);

					this.panelWorkspace.Controls.Add(lblItem);
					dCurrentY += lblItem.Height;
				}
				while( sDesc.Length > 0 );
			}
			this.Size = new Size(this.Width, dCurrentY);
		}

		private Label CreateLabel( string sText )
		{
			System.Windows.Forms.Label lblItem = new Label();

			lblItem.Text = sText;
			lblItem.TextAlign = System.Drawing.ContentAlignment.TopLeft;
			lblItem.Font = new System.Drawing.Font("Tahoma", 8F);

			return( lblItem );
		}
		private float GetTextWidth( Label oLabel,string sText )
		{
			if( sText.Length == 0 )
			{
				return( 0 );
			}
			else
			{
				System.Drawing.Graphics oGraphics = oLabel.CreateGraphics();
				System.Drawing.RectangleF rect = new System.Drawing.RectangleF(0, 0, 10000, 10000);
				System.Drawing.StringFormat fmt = createStringFormat();
				fmt.SetMeasurableCharacterRanges(new System.Drawing.CharacterRange[] { new System.Drawing.CharacterRange(0, sText.Length ) });


				System.Drawing.Region[] rgns = oGraphics.MeasureCharacterRanges(sText, oLabel.Font, rect, fmt);
				System.Drawing.Region oRegion = rgns[0];
				rect = oRegion.GetBounds( oGraphics );


				oGraphics.Dispose();
				return( rect.Width );
			}
		}
		private System.Drawing.StringFormat createStringFormat()
		{
			System.Drawing.StringFormat fmt = System.Drawing.StringFormat.GenericTypographic;
			fmt.Trimming = System.Drawing.StringTrimming.None;
			fmt.FormatFlags = System.Drawing.StringFormatFlags.MeasureTrailingSpaces | System.Drawing.StringFormatFlags.NoWrap;
			return fmt;
		}


		private void DSHoverForm_Load(object sender, System.EventArgs e)
		{
			timerFadeIn.Enabled = true;
			m_oStartingMousePt = new Point(System.Windows.Forms.Control.MousePosition.X, System.Windows.Forms.Control.MousePosition.Y);
			timerMouseMonitor.Enabled = true;
			InitScreen();

			this.Location = new Point( DSMisc.Min( Screen.PrimaryScreen.Bounds.Right - this.Width,m_oStartingMousePt.X + 1 ), 
									   m_oStartingMousePt.Y - this.Height - 1 );
			
			this.Deactivate += new EventHandler(DSHoverForm_Deactivate);
		}

		private void timerFadeIn_Tick(object sender, System.EventArgs e)
		{
			if (this.Opacity < 1.0)
			{
				this.Opacity += .25;
			}
			else
			{
				this.timerFadeIn.Enabled = false;
			}
		}

		private void timerFadeOut_Tick(object sender, System.EventArgs e)
		{
			timerFadeIn.Enabled = false;
			if (this.Opacity > .1)
			{
				this.Opacity -= .25;
			}
			else
			{
				this.Opacity = 0.0;
				timerFadeOut.Enabled = false;
				this.Close();
			}
		}

		private void timerMouseMonitor_Tick(object sender, System.EventArgs e)
		{
			double nDistMoved = 0;
			System.Drawing.Point oCurMousePt = System.Windows.Forms.Control.MousePosition;


			nDistMoved = DSMisc.Distance( oCurMousePt.X,oCurMousePt.Y,m_oStartingMousePt.X,m_oStartingMousePt.Y );
			if( nDistMoved > 5 )
			{
				timerMouseMonitor.Enabled = false;
				timerFadeOut.Enabled = true;
			}
			else
			{
				m_oStartingMousePt = oCurMousePt;
			}
		}

		private void DSHoverForm_Deactivate(object sender, EventArgs e)
		{
			this.Activate();
			timerMouseMonitor.Enabled = false;
			timerFadeOut.Enabled = true;
		}



		#region Properties
		public string Caption
		{
			set
			{
				m_sCaption = value;
			}
		}

		public System.Collections.ArrayList PopupStrings
		{
			set 
			{
				m_arrLines = value;
			}
		}
		#endregion
	}
}
